/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.api.wrapper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.scoreboard.IScoreCriteria;
import net.minecraft.scoreboard.Score;
import net.minecraft.scoreboard.ScoreObjective;
import net.minecraft.scoreboard.ScorePlayerTeam;
import net.minecraft.scoreboard.Scoreboard;
import net.minecraft.server.MinecraftServer;
import noppes.npcs.api.CustomNPCsException;
import noppes.npcs.api.IScoreboard;
import noppes.npcs.api.IScoreboardObjective;
import noppes.npcs.api.IScoreboardTeam;
import noppes.npcs.api.wrapper.ScoreboardObjectiveWrapper;
import noppes.npcs.api.wrapper.ScoreboardTeamWrapper;
import noppes.npcs.reflection.scoreboard.ScoreboardReflection;

public class ScoreboardWrapper
implements IScoreboard {
    private final Scoreboard board;
    private final MinecraftServer server;

    protected ScoreboardWrapper(MinecraftServer server) {
        this.server = server;
        this.board = server.func_71218_a(0).func_96441_U();
    }

    @Override
    public IScoreboardObjective addObjective(String objective, String criteria) {
        IScoreCriteria icriteria = (IScoreCriteria)IScoreCriteria.field_96643_a.get(criteria);
        if (icriteria == null) {
            throw new CustomNPCsException("Unknown score criteria: %s", criteria);
        }
        if (objective.isEmpty() || objective.length() > 16) {
            throw new CustomNPCsException("Score objective must be between 1-16 characters: %s", objective);
        }
        ScoreObjective obj = this.board.func_96535_a(objective, icriteria);
        return new ScoreboardObjectiveWrapper(this.board, obj);
    }

    @Override
    public IScoreboardTeam addTeam(String name) {
        if (this.hasTeam(name)) {
            throw new CustomNPCsException("Team %s already exists", name);
        }
        return new ScoreboardTeamWrapper(this.board.func_96527_f(name), this.board);
    }

    @Override
    public void deletePlayerScore(String player, String objective, String datatag) {
        ScoreObjective obj = this.getObjectiveWithException(objective);
        if (!this.test(datatag)) {
            return;
        }
        if (this.board.func_96510_d(player).remove(obj) != null) {
            this.board.func_96524_g(player);
        }
    }

    @Override
    public IScoreboardObjective getObjective(String name) {
        ScoreObjective obj = this.board.func_96518_b(name);
        if (obj == null) {
            return null;
        }
        return new ScoreboardObjectiveWrapper(this.board, obj);
    }

    @Override
    public IScoreboardObjective[] getObjectives() {
        ArrayList collection = new ArrayList(this.board.func_96514_c());
        IScoreboardObjective[] objectives = new IScoreboardObjective[collection.size()];
        for (int i = 0; i < collection.size(); ++i) {
            objectives[i] = new ScoreboardObjectiveWrapper(this.board, (ScoreObjective)collection.get(i));
        }
        return objectives;
    }

    private ScoreObjective getObjectiveWithException(String objective) {
        ScoreObjective obj = this.board.func_96518_b(objective);
        if (obj == null) {
            throw new CustomNPCsException("Score objective does not exist: %s", objective);
        }
        return obj;
    }

    @Override
    public String[] getPlayerList() {
        Collection collection = this.board.func_96526_d();
        return collection.toArray(new String[0]);
    }

    @Override
    public int getPlayerScore(String player, String objective, String datatag) {
        ScoreObjective obj = this.getObjectiveWithException(objective);
        if (obj.func_96680_c().func_96637_b() || !this.test(datatag)) {
            return 0;
        }
        return this.board.func_96529_a(player, obj).func_96652_c();
    }

    @Override
    public IScoreboardTeam getPlayerTeam(String player) {
        ScorePlayerTeam team = this.board.func_96509_i(player);
        if (team == null) {
            return null;
        }
        return new ScoreboardTeamWrapper(team, this.board);
    }

    @Override
    public IScoreboardTeam getTeam(String name) {
        ScorePlayerTeam team = this.board.func_96508_e(name);
        return new ScoreboardTeamWrapper(team, this.board);
    }

    @Override
    public IScoreboardTeam[] getTeams() {
        ArrayList list = new ArrayList(this.board.func_96525_g());
        IScoreboardTeam[] teams = new IScoreboardTeam[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            teams[i] = new ScoreboardTeamWrapper((ScorePlayerTeam)list.get(i), this.board);
        }
        return teams;
    }

    @Override
    public boolean hasObjective(String objective) {
        return this.board.func_96518_b(objective) != null;
    }

    @Override
    public boolean hasPlayerObjective(String player, String objective, String datatag) {
        ScoreObjective obj = this.getObjectiveWithException(objective);
        return this.test(datatag) && this.board.func_96510_d(player).get(obj) != null;
    }

    @Override
    public boolean hasTeam(String name) {
        Map<String, ScorePlayerTeam> teams = ScoreboardReflection.getTeams(this.board);
        return teams == null || teams.containsKey(name);
    }

    @Override
    public void removeObjective(String objective) {
        ScoreObjective obj = this.board.func_96518_b(objective);
        if (obj != null) {
            this.board.func_96519_k(obj);
        }
    }

    @Override
    public void removePlayerTeam(String player) {
        this.board.func_96524_g(player);
    }

    @Override
    public void removeTeam(String name) {
        Map<String, ScorePlayerTeam> teams = ScoreboardReflection.getTeams(this.board);
        if (teams != null && teams.containsKey(name)) {
            this.board.func_96511_d(teams.get(name));
        }
    }

    @Override
    public void setPlayerScore(String player, String objective, int score, String datatag) {
        ScoreObjective obj = this.getObjectiveWithException(objective);
        if (obj.func_96680_c().func_96637_b() || !this.test(datatag)) {
            return;
        }
        Score sco = this.board.func_96529_a(player, obj);
        sco.func_96647_c(score);
    }

    private boolean test(String datatag) {
        if (datatag.isEmpty()) {
            return true;
        }
        try {
            Entity entity = CommandBase.func_184885_b((MinecraftServer)this.server, (ICommandSender)this.server, (String)datatag);
            NBTTagCompound nbttagcompound = JsonToNBT.func_180713_a((String)datatag);
            NBTTagCompound compound = new NBTTagCompound();
            entity.func_189511_e(compound);
            return NBTUtil.func_181123_a((NBTBase)nbttagcompound, (NBTBase)compound, (boolean)true);
        }
        catch (Exception e) {
            return false;
        }
    }
}

